using System;
using System.Configuration;
using System.Runtime.Serialization;
using System.Security.Permissions;

using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.Common
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carrie Van Stedum</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>3/12/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Exception class used to represent data access related errors / rule
	///	violations and wrap exceptions occured within data access layer.  
	///</summary>

	
	[Serializable]
	public class DataAccessLayerException : BaseApplicationException
	{
		private const string DBCONNECTION = "dbConnectionString";

		/// <summary>
		/// Connection string
		/// </summary>
		protected static string connectionString = "workstation id=" + Environment.MachineName + ";" + System.Configuration.ConfigurationManager.AppSettings["ConnectionString"]; 

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/12/2003</CreationDate>
		///	<TestCases>
		///	<Case type="0" testid ="3132"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///	<Case type="1" testid ="1162"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Default constructor. 
		///</summary>
		public DataAccessLayerException() : base()
		{
		}


		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/12/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="3137"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///	<Case type="1" testid ="3134"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>null reference exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Constructor getting error message text as an input parameter.
		///</summary>
		///<param name="message">Error message</param>
		public DataAccessLayerException(string message) : base(message)
		{
		} 


		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/12/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="3135"> 
		///		<ExpectedInput>Valid string and exception</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3136"> 
		///		<ExpectedInput>Invalid string and exception</ExpectedInput>
		///		<ExpectedOutput>Null reference exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Constructor getting error message text and inner 
		///	exception as an input parameters.
		///</summary>
		///<param name="message">Error message</param>
		///<param name="inner">Inner exception</param>
		public DataAccessLayerException(string message, Exception inner) : base(message, inner)
		{
		}


		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/12/2003</CreationDate>
		///<summary>
		///	Constructor used for serialization.
		///</summary>
		///<param name="info">Serialization info</param>
		///<param name="context">Streaming context</param>
		protected DataAccessLayerException(SerializationInfo info, StreamingContext context) : base (info, context)
		{  
			connectionString = info.GetString(DBCONNECTION);
		}
	
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/12/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3127"> 
		///		<ExpectedInput>Valid serialization info and context</ExpectedInput>
		///		<ExpectedOutput>No exception</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3128"> 
		///		<ExpectedInput>Valid serialization info and context</ExpectedInput>
		///		<ExpectedOutput>Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Gets object data for serialization purposes.
		///</summary>
		///<param name="info">Serialization info</param>
		///<param name="context">Streaming context</param>
		[SecurityPermission(SecurityAction.Demand, SerializationFormatter = true)]
		public override void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			info.AddValue(DBCONNECTION, connectionString, typeof(string));
			base.GetObjectData(info, context);
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3133"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///<Case type="1" testid ="1163"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Connection string
		/// </summary>
		public string DBConnectionString
		{
			get
			{
				return connectionString;
			}
		}
	}
}